/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.tileentity;

import dev.toma.gunsrpg.common.init.ModBlockEntities;
import dev.toma.gunsrpg.common.init.ModRecipeTypes;
import dev.toma.gunsrpg.common.tileentity.VanillaInventoryTileEntity;
import dev.toma.gunsrpg.resource.blasting.BlastingRecipe;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IRecipeHelperPopulator;
import net.minecraft.inventory.IRecipeHolder;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class BlastFurnaceTileEntity
extends VanillaInventoryTileEntity
implements IRecipeHolder,
IRecipeHelperPopulator,
ITickableTileEntity,
ISidedInventory {
    private static final byte SLOT_INPUT = 0;
    private static final byte SLOT_FUEL = 1;
    private static final byte SLOT_OUTPUT = 2;
    private final Object2IntOpenHashMap<ResourceLocation> usedRecipes = new Object2IntOpenHashMap();
    private final IRecipeType<BlastingRecipe> recipeType;
    private int litTime;
    private int litDuration;
    private int cookingProgress;
    private int cookingTotalTime;
    private final IIntArray data = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return BlastFurnaceTileEntity.this.litTime;
                }
                case 1: {
                    return BlastFurnaceTileEntity.this.litDuration;
                }
                case 2: {
                    return BlastFurnaceTileEntity.this.cookingProgress;
                }
                case 3: {
                    return BlastFurnaceTileEntity.this.cookingTotalTime;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    BlastFurnaceTileEntity.this.litTime = value;
                    break;
                }
                case 1: {
                    BlastFurnaceTileEntity.this.litDuration = value;
                    break;
                }
                case 2: {
                    BlastFurnaceTileEntity.this.cookingProgress = value;
                    break;
                }
                case 3: {
                    BlastFurnaceTileEntity.this.cookingTotalTime = value;
                }
            }
        }

        public int func_221478_a() {
            return 4;
        }
    };

    public BlastFurnaceTileEntity() {
        this((TileEntityType<? extends BlastFurnaceTileEntity>)((TileEntityType)ModBlockEntities.BLAST_FURNACE.get()));
    }

    protected BlastFurnaceTileEntity(TileEntityType<? extends BlastFurnaceTileEntity> type) {
        super((TileEntityType<? extends VanillaInventoryTileEntity>)type);
        this.recipeType = ModRecipeTypes.BLASTING_RECIPE_TYPE;
    }

    public IIntArray getData() {
        return this.data;
    }

    @Override
    public IItemHandlerModifiable createInventory() {
        return new ItemStackHandler(3);
    }

    @Override
    public void read(CompoundNBT nbt) {
        this.litTime = nbt.func_74762_e("litTime");
        LazyOptional<IItemHandlerModifiable> optional = this.getInventory();
        this.litDuration = optional.isPresent() ? this.getBurnDuration(((IItemHandlerModifiable)optional.orElse(null)).getStackInSlot(1)) : 0;
        this.cookingProgress = nbt.func_74762_e("cookingProgress");
        this.cookingTotalTime = nbt.func_74762_e("cookingTotalTime");
        CompoundNBT used = nbt.func_74775_l("usedRecipes");
        for (String key : used.func_150296_c()) {
            this.usedRecipes.put((Object)new ResourceLocation(key), used.func_74762_e(key));
        }
    }

    @Override
    public void write(CompoundNBT nbt) {
        nbt.func_74768_a("litTime", this.litTime);
        nbt.func_74768_a("cookingProgress", this.cookingProgress);
        nbt.func_74768_a("cookingTotalTime", this.cookingTotalTime);
        CompoundNBT used = new CompoundNBT();
        this.usedRecipes.forEach((k, v) -> used.func_74768_a(k.toString(), v.intValue()));
        nbt.func_218657_a("usedRecipes", (INBT)used);
    }

    public void func_73660_a() {
        boolean wasLit = this.isLit();
        boolean gotLit = false;
        if (this.isLit()) {
            --this.litTime;
        }
        ItemStack fuelStack = this.itemHandler.getStackInSlot(1);
        if (this.isLit() || !fuelStack.func_190926_b() && !this.itemHandler.getStackInSlot(0).func_190926_b()) {
            IRecipe recipe = this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)this, this.field_145850_b).orElse(null);
            if (!this.isLit() && this.canBurn(recipe)) {
                this.litDuration = this.litTime = this.getBurnDuration(fuelStack);
                if (this.isLit()) {
                    gotLit = true;
                    if (fuelStack.hasContainerItem()) {
                        this.itemHandler.setStackInSlot(1, fuelStack.getContainerItem());
                    } else if (!fuelStack.func_190926_b()) {
                        fuelStack.func_190918_g(1);
                        if (fuelStack.func_190926_b()) {
                            this.itemHandler.setStackInSlot(1, fuelStack.getContainerItem());
                        }
                    }
                }
            }
            if (this.isLit() && this.canBurn(recipe)) {
                ++this.cookingProgress;
                if (this.cookingProgress == this.cookingTotalTime) {
                    this.cookingProgress = 0;
                    this.cookingTotalTime = this.getTotalCookTime();
                    this.burn(recipe);
                    gotLit = true;
                }
            } else {
                this.cookingProgress = 0;
            }
        } else if (!this.isLit() && this.cookingProgress > 0) {
            this.cookingProgress = MathHelper.func_76125_a((int)(this.cookingProgress - 2), (int)0, (int)this.cookingTotalTime);
        }
        if (wasLit != this.isLit() && !this.field_145850_b.field_72995_K) {
            gotLit = true;
            this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.field_145850_b.func_180495_p(this.field_174879_c).func_206870_a((Property)BlockStateProperties.field_208190_q, (Comparable)Boolean.valueOf(this.isLit())), 3);
        }
        if (gotLit && !this.field_145850_b.field_72995_K) {
            this.func_70296_d();
        }
    }

    @Nullable
    public IRecipe<?> func_193055_i() {
        return null;
    }

    public void func_193056_a(@Nullable IRecipe<?> recipe) {
        if (recipe != null) {
            ResourceLocation id = recipe.func_199560_c();
            this.usedRecipes.addTo((Object)id, 1);
        }
    }

    public void func_201560_d(PlayerEntity p_201560_1_) {
    }

    public void func_194018_a(RecipeItemHelper helper) {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            helper.func_194112_a(this.itemHandler.getStackInSlot(i));
        }
    }

    public int[] func_180463_a(Direction direction) {
        int[] nArray;
        if (direction == Direction.DOWN) {
            return new int[]{1, 2};
        }
        if (direction == Direction.UP) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 1;
        }
        return nArray;
    }

    public boolean func_180462_a(int slot, ItemStack stack, @Nullable Direction direction) {
        return this.func_94041_b(slot, stack);
    }

    public boolean func_180461_b(int slot, ItemStack stack, Direction direction) {
        if (direction == Direction.DOWN && slot == 1) {
            Item item = stack.func_77973_b();
            return item == Items.field_151131_as || item == Items.field_151133_ar;
        }
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (slot == 2) {
            return false;
        }
        if (slot != 1) {
            return true;
        }
        ItemStack fuelStack = this.func_70301_a(1);
        return ForgeHooks.getBurnTime((ItemStack)stack, this.recipeType) > 0 || stack.func_77973_b() == Items.field_151133_ar && fuelStack.func_77973_b() != Items.field_151133_ar;
    }

    @Override
    public void func_70299_a(int id, ItemStack stack) {
        ItemStack itemStack = this.itemHandler.getStackInSlot(id);
        boolean flag = !stack.func_190926_b() && stack.func_77969_a(itemStack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)itemStack);
        this.itemHandler.setStackInSlot(id, stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        if (id == 0 && !flag) {
            this.cookingTotalTime = this.getTotalCookTime();
            this.cookingProgress = 0;
            this.func_70296_d();
        }
    }

    public void awardUsedRecipeAndAddExp(PlayerEntity player) {
        List<IRecipe<?>> recipeList = this.getRecipesForAwardsWithExp(player.field_70170_p, player.func_213303_ch());
        player.func_195065_a(recipeList);
        this.usedRecipes.clear();
    }

    public List<IRecipe<?>> getRecipesForAwardsWithExp(World level, Vector3d position) {
        ArrayList list = new ArrayList();
        for (Object2IntMap.Entry entry : this.usedRecipes.object2IntEntrySet()) {
            level.func_199532_z().func_215367_a((ResourceLocation)entry.getKey()).ifPresent(recipe -> {
                list.add((IRecipe<?>)recipe);
                this.createExperience(level, position, entry.getIntValue(), ((BlastingRecipe)recipe).getExperience());
            });
        }
        return list;
    }

    private void createExperience(World level, Vector3d position, int count, float value) {
        int i = MathHelper.func_76141_d((float)((float)count * value));
        float f = MathHelper.func_226164_h_((float)((float)count * value));
        if (f != 0.0f && Math.random() < (double)f) {
            ++i;
        }
        while (i > 0) {
            int expVal = ExperienceOrbEntity.func_70527_a((int)i);
            i -= expVal;
            level.func_217376_c((Entity)new ExperienceOrbEntity(level, position.field_72450_a, position.field_72448_b, position.field_72449_c, expVal));
        }
    }

    private int getBurnDuration(ItemStack stack) {
        return stack.func_190926_b() ? 0 : ForgeHooks.getBurnTime((ItemStack)stack, this.recipeType);
    }

    private int getTotalCookTime() {
        return this.field_145850_b.func_199532_z().func_215371_a(this.recipeType, (IInventory)this, this.field_145850_b).map(BlastingRecipe::getCookTime).orElse(800);
    }

    private boolean canBurn(IRecipe<?> recipe) {
        if (!this.itemHandler.getStackInSlot(0).func_190926_b() && recipe != null) {
            ItemStack stack = recipe.func_77572_b((IInventory)this);
            int recipeResultCount = stack.func_190916_E();
            if (stack.func_190926_b()) {
                return false;
            }
            ItemStack outputStack = this.itemHandler.getStackInSlot(2);
            if (outputStack.func_190926_b()) {
                return true;
            }
            if (!outputStack.func_77969_a(stack)) {
                return false;
            }
            if (outputStack.func_190916_E() + recipeResultCount <= this.func_70297_j_() && outputStack.func_190916_E() + recipeResultCount <= outputStack.func_77976_d()) {
                return true;
            }
            return outputStack.func_190916_E() + recipeResultCount <= stack.func_77976_d();
        }
        return false;
    }

    private void burn(IRecipe<?> recipe) {
        if (recipe != null && this.canBurn(recipe)) {
            ItemStack inputStack = this.itemHandler.getStackInSlot(0);
            ItemStack resultStack = recipe.func_77572_b((IInventory)this);
            ItemStack outputStack = this.itemHandler.getStackInSlot(2);
            if (outputStack.func_190926_b()) {
                ItemStack resultCopy = resultStack.func_77946_l();
                this.itemHandler.setStackInSlot(2, resultCopy);
            } else if (outputStack.func_77973_b() == resultStack.func_77973_b()) {
                outputStack.func_190917_f(resultStack.func_190916_E());
            }
            if (!this.field_145850_b.field_72995_K) {
                this.func_193056_a(recipe);
            }
            inputStack.func_190918_g(1);
        }
    }

    public boolean isLit() {
        return this.litTime > 0;
    }
}

